import {
    setOperationalSystem,
    setBrowser,
    setBlackboxData,
    setSecretKey,
    setYandexUid,
    setNetworkTraits,
    setIsBot,
} from '../../common/actions/user';

import isModernBrowser from '../../common/lib/isModernBrowser';

export default function storeUser({store, req, next}) {
    const {
        OSFamily,
        OSVersion,
        BrowserName,
        BrowserVersion,
        BrowserBase,
        BrowserBaseVersion,
    } = req.uatraits;

    store.dispatch(
        setOperationalSystem({
            name: OSFamily,
            version: OSVersion,
        }),
    );

    const browserInfo = {
        name: BrowserName,
        version: BrowserVersion,
        base: BrowserBase,
        baseVersion: BrowserBaseVersion,
    };

    browserInfo.isModern = isModernBrowser(browserInfo);

    store.dispatch(setBrowser(browserInfo));
    store.dispatch(setBlackboxData(req.blackbox));
    store.dispatch(setNetworkTraits(req.networkTraits));
    store.dispatch(setYandexUid(req.cookies.yandexuid));
    store.dispatch(setSecretKey(req.secretkey));
    store.dispatch(setIsBot(req.isBot));
    next();
}
