import {Request, Response, NextFunction} from 'express';

import IExpressRequest from '../../common/interfaces/IExpressRequest';

import {getUserFlags} from '../helpers/getUserFlags';

export default function userFlags(
    req: Request & Pick<IExpressRequest, 'flags' | 'networkTraits'>,
    res: Response,
    next: NextFunction,
): void {
    req.flags = {
        ...req.flags,
        ...getUserFlags(req, res),
    };

    next();
}
