import {Request, Response, NextFunction} from 'express';

import IExpressRequest from '../../common/interfaces/IExpressRequest';

import {getUserNetworkTraits} from '../helpers/geobaseHelper';

export default function (
    req: Request & Pick<IExpressRequest, 'networkTraits'>,
    res: Response,
    next: NextFunction,
): void {
    getUserNetworkTraits(req)
        .then(traits => {
            if (traits) {
                const isYandexNetwork = Boolean(
                    traits.yandex_net ?? traits.is_yandex_net,
                );

                req.networkTraits = {isYandexNetwork};
            }

            next();
        })
        .catch(() => {
            next();
        });
}
