import {setupApi} from './api';
import {SEARCH_TRANSPORT_TYPES} from '../common/lib/transportType';

import Environment from '../common/interfaces/Environment';

import userFlags from './middleware/userFlags';
import abtExperiments from './middleware/abtExperiments';

const USE_HTTP_SERVICES = process.env.USE_HTTP_SERVICES;
const searchTransportTypesRegexp = SEARCH_TRANSPORT_TYPES.join('|');
const useTvm =
    process.env.NODE_ENV !== Environment.development &&
    process.env.RASP_CONTAINER_RUN_LOCALLY !== '1';

export default function (app, config) {
    const {uatraits} = config;

    // Common Yandex stuff
    app.use(require('@yandex-int/express-x-forwarded-for-fix')());

    // Определение информации о браузере (req.uatraits)
    if (USE_HTTP_SERVICES) {
        app.use(require('@yandex-int/express-http-uatraits')());
    } else {
        app.use(
            require('@yandex-int/express-uatraits')({
                browser: uatraits.browser,
                profiles: uatraits.profiles,
                uatraits: uatraits.module,
            }),
        );
    }

    // Кука yandexuid
    app.use(require('@yandex-int/express-yandexuid')());

    // We need to store whether request has yandexuid or no
    app.use(require('./middleware/checkYandexUid'));

    if (useTvm) {
        app.use(require('@yandex-int/express-tvm').default(config.tvm));
    }

    app.use(require('@yandex-int/express-blackbox')(config.blackbox));
    app.use(require('@yandex-int/express-renew-bb-session')());
    app.use(require('./middleware/isTouchDomain'));
    app.use(require('./middleware/addIsExpressRequest').default);

    if (USE_HTTP_SERVICES) {
        app.use(
            require('@yandex-int/express-http-geobase')(config.httpGeobase),
        );
        app.use(
            require('@yandex-int/express-http-langdetect')(config.langdetect),
        );
    } else {
        app.use(
            require('@yandex-int/express-langdetect').default(
                config.langdetect,
            ),
        );
    }

    app.use(
        require('./middleware/national-redirect')(config, USE_HTTP_SERVICES),
    );
    app.use(require('@yandex-int/express-secretkey')());

    // Project level middleware
    app.use(require('./middleware/bot').default);

    // АБТ эксперименты
    app.use(abtExperiments);

    setupApi(app);

    app.use(require('./middleware/expressFullUrl').default);
    app.use(require('./middleware/processLanguage'));
    app.use('/search/next', require('./middleware/searchNext'));
    app.use(
        `/search/:transportType(${searchTransportTypesRegexp})/next`,
        require('./middleware/searchNext'),
    );
    app.use(require('./middleware/altLinks').default(config.altLangDomains));
    app.use(require('./middleware/altRedirects').default);
    // Наши эксперименты
    app.use(require('./middleware/experiments'));
    // Пользовательские флаги (выставляются через параметры/куки)
    app.use(userFlags);
}
