import template from './template';
import cookies from './helpers/cookies';
import getLinkToTracer from './helpers/jaeger/getLinkToTracer';

export default function routerAdapter(app, injectToCreateStore, injections) {
    app.use((req, res, next) => {
        req._cookies = cookies(req, res);
        req._store = injectToCreateStore({
            ...injections,
            cookies: req._cookies,
        })({
            nonce: req.nonce,
            linkToTracer: req.jaegerDebugId
                ? getLinkToTracer(req.jaegerDebugId)
                : null,
        });

        next();
    });

    const wrap = cb => (req, res, next) => {
        res.render = () => {
            return template(req, req._store, res);
        };

        cb({
            ...injections,
            store: req._store,
            cookies: req._cookies,
            res,
            req,
            next,
        });
    };

    return {
        originalApp: app,
        wrap,

        use(route, cb) {
            app.use(route, wrap(cb));
        },

        get(route, cb) {
            app.get(route, wrap(cb));
        },

        post(route, cb) {
            app.post(route, wrap(cb));
        },
    };
}
