import {Bundle} from 'react-loadable/webpack';

/*
Скрипт добавляет css-чанки в head документа.
В идеале не должно происходить ситуации, когда после серверного рендеринга требуется загрузить
еще какие-то css-файлы, но это страховка на случай ошибки разработчиков.
Подробнее смотри в файле server/template/getCssLoadableChunksByPageType.ts.
 */
export default function (
    nonce: string,
    cssChunks: Bundle[],
    bundleHost: string,
): string {
    if (!cssChunks.length) {
        return '';
    }

    /* eslint-disable indent */
    return `<script nonce="${nonce}">
            (function(){
                var head = document.getElementsByTagName('head')[0];

                ${cssChunks
                    .map((chunk, index) => {
                        const varName = `cssChunk${index}`;

                        return `var ${varName} = document.createElement('link');
                            ${varName}.rel = 'stylesheet';
                            ${varName}.href = '${bundleHost}/${chunk.file}';
                            head.appendChild(${varName});`;
                    })
                    .join()}
            })()
            </script>`;
    /* eslint-enable indent */
}
