import environment from '@yandex-int/yandex-environment';

import Environment from '../../common/interfaces/Environment';

const url500 =
    environment !== Environment.development ? '/500.html' : '/500.ru.html';

export default function (nonce: string): string {
    return ` <script nonce="${nonce}">
        document.addEventListener('DOMContentLoaded',  function(){
            var appFullLoaded = document.getElementById('appFullLoaded');

            if (appFullLoaded){
                return;
            }

            if(Ya && Ya.Rum && typeof Ya.Rum.logError === 'function') {
                Ya.Rum.logError({
                    message: 'Failed to send',
                    level: 'error',
                    source: 'server/template/errorRenderingScript.ts'
                });
            }

            var request = new XMLHttpRequest();
            var html = '';

            request.open('GET', '${url500}', false);
            request.send();

            if(request.status === 200){
                var match = request.responseText.match(/<html[^>]*>([\\s\\S]+)<\\/html>/i);

                if (match) {
                    html = match[1];
                }
            }

            if (!html){
                html = '<head></head><body>На странице произошла ошибка.' +
                'Попробуйте перезагрузить страницу.</body>';
            }

            document.getElementsByTagName('html')[0].innerHTML = html;
        });
    </script>
    `;
}
