import fs from 'fs-extra';
import environment from '@yandex-int/yandex-environment';
import {Manifest} from 'react-loadable/webpack';

import Environment from '../../common/interfaces/Environment';

import {
    getPathForReactLoadableJson,
    IBundlePath,
} from '../../webpack/staticUtils';

const cache: Record<string, Manifest> = {};

function readFile({platform, language, modernBrowser}: IBundlePath): Manifest {
    return fs.readJsonSync(
        getPathForReactLoadableJson({
            platform,
            language,
            modernBrowser,
        }),
    );
}

export default function ({
    platform,
    language,
    modernBrowser,
}: IBundlePath): Manifest {
    if (environment === Environment.development) {
        return readFile({platform, language, modernBrowser});
    }

    const key = `${platform}-${language}-${modernBrowser}`;

    if (!cache[key]) {
        cache[key] = readFile({platform, language, modernBrowser});
    }

    return cache[key];
}
