import fs from 'fs-extra';
import environment from '@yandex-int/yandex-environment';

import Environment from '../../common/interfaces/Environment';

import {getPathForSvgSprite, IBundlePath} from '../../webpack/staticUtils';

const cache: Record<string, string> = {};

function readFile({platform, language, modernBrowser}: IBundlePath): string {
    return fs.readFileSync(
        getPathForSvgSprite({
            platform,
            language,
            modernBrowser,
        }),
        {encoding: 'utf8'},
    );
}

export default function ({
    platform,
    language,
    modernBrowser,
}: IBundlePath): string {
    if (environment === Environment.development) {
        return readFile({platform, language, modernBrowser});
    }

    const key = `${platform}-${language}-${modernBrowser}`;

    if (!cache[key]) {
        cache[key] = readFile({platform, language, modernBrowser});
    }

    return cache[key];
}
