'use strict';

process.setMaxListeners(1024);

const environment = require('@yandex-int/yandex-environment');
const path = require('path');
const fs = require('fs');
const https = require('https');

if (environment === 'development') {
    require('../transpilerOnFly');
}

const config = require('@yandex-int/yandex-config')();
const moment = require('../reexports').momentTimezone;

moment.tz.setDefault(config.defaultTimezone);

const recordMemoryInfo = require('./helpers/memory/recordMemoryInfo').default;
const app = require('./app.js').default;
const prefix = `index.js (${config.app.version})`;
const log = require('./logger').default;
const worker = require('cluster').worker;
const pid = worker ? worker.process.pid : process.pid;

const endpoint = config.server.port || config.server.socket;
const listenStarted = () => {
    if (config.server.socket && !config.server.port) {
        // Allow nginx access to socket
        fs.chmodSync(config.server.socket, '777');
    }

    log.info(prefix, `[${pid}] Worker spawned`);
};

if (process.env.LOCAL_HTTPS) {
    fs.readFile(
        path.join(__dirname, '/../certs/l.rasp.yandex.ru.pem'),
        (err, certFileData) => {
            if (err) {
                throw err;
            }

            https
                .createServer(
                    {
                        key: certFileData,
                        cert: certFileData,
                    },
                    app,
                )
                .listen(endpoint, listenStarted);
        },
    );
} else {
    app.listen(endpoint, listenStarted);
}

// Для создания снэпшотов кучи и информации об использовании памяти.
// Для создания файлов нужно выполнить команду $ kill -USR2 <pid>
// Файлы будут располагаться в директории /reports/memory/<pid>/2020-09-08_09-39-00/
process.on('SIGUSR2', recordMemoryInfo);
