import crypto from 'crypto';

import {IMAGE_NAME} from './constants';

import {getManifest} from '../../server/helpers/distribution/getManifest';

export async function getDockerHash(tag: string): Promise<string> {
    const manifest = await getManifest(IMAGE_NAME, tag);

    return `sha256:${crypto
        .createHash('sha256')
        .update(manifest)
        .digest('hex')}`;
}
