import {spawn} from 'child_process';

// Выполняет скрипт с потоковым выводом в консоль
export default function exec(command: string, args?: string[]): Promise<void> {
    // eslint-disable-next-line no-console
    console.log(`$ ${command}`);

    const argsFromProps = args ?? [];

    return new Promise((resolve, reject) => {
        const argsFromCommand = command.split(' ');

        const proc = spawn(
            argsFromCommand[0],
            [...argsFromCommand.slice(1), ...argsFromProps],
            {stdio: 'inherit'},
        );

        proc.on('error', reject);

        proc.on('close', code => {
            if (code === 0) {
                return resolve();
            }

            reject(`Command "${command}" exit with code ${code}`);
        });
    });
}
