/* eslint-disable no-console */
import {exec} from 'child_process';
import {promisify} from 'util';

const execPromised = promisify(exec);

// Выполняет shell-команду. Но ввиду того, что она сначала дожидается полного выполнения
// команды и только потом отдает результат, данная функция не подходит для комманд, вывод которых
// нужно видеть потоково. Для этого есть функция ./exec.ts
export default async function execShellCommand(
    command: string,
    logResult = true,
    logCommand = true,
): Promise<{stdout: string; stderr: string}> {
    if (logCommand) {
        console.log(`$ ${command}`);
    }

    const result = await execPromised(command);

    if (logResult) {
        console.log(result.stdout);
    }

    return result;
}
