import fse from 'fs-extra';
import path from 'path';

import IDataRequest from '../../../common/interfaces/tests/IDataRequest';

export default async function getDataForRequests(): Promise<IDataRequest[]> {
    const pathFile = path.join(__dirname, './urls.txt');
    const data = await fse.readFile(pathFile, {encoding: 'utf-8'});
    const strings = data.split('\n').filter(Boolean);

    return strings.map(string => {
        return JSON.parse(string) as IDataRequest;
    });
}
