import IReport from '../../../common/interfaces/tests/IReport';

export default class Report implements IReport {
    protected errors: any[] = [];
    protected info: string[] = [];

    pushError(error: any): void {
        this.errors.push(error);
    }

    getCountErrors(): number {
        return this.errors.length;
    }

    errorsToTxt(): string {
        return this.errors.map(error => `${error}\n\n`).join('');
    }

    clearErrors(): void {
        this.errors = [];
    }

    pushInfo(message: string): void {
        this.info.push(message);
    }

    infotoTxt(): string {
        return this.info.map(info => `${info}\n\n`).join('');
    }

    clearInfo(): void {
        this.info = [];
    }
}
