import IPageData from '../../../common/interfaces/tests/IPageData';
import FactoryOfPromise from '../../../common/interfaces/FactoryOfPromise';
import IReport from '../../../common/interfaces/tests/IReport';

import getLinksFromPage from './getLinksFromPage';
import getPage from './getPage';
import stringifyPageData from './stringifyPageData';
import stringifyRequest from './stringifyRequest';

export default function checkValidLinksOnPage(
    pageData: IPageData,
    report: IReport,

    filter?: (link: string) => boolean,
    expectedCode?: number,
): FactoryOfPromise[] {
    const {body, headers, url} = pageData;

    expectedCode = expectedCode ?? 200;

    return getLinksFromPage(body, url)
        .filter(link => (filter ? filter(link) : true))
        .map(link => async () => {
            const requestData = {
                url: link,
                headers,
            };

            const errInfo =
                `${stringifyRequest(requestData)}\n` +
                `Источник: ${stringifyPageData(pageData)}`;

            const pageDataLink = await getPage(requestData).catch(err => {
                throw new Error(
                    'Не валидная ссылка\n' +
                        `${errInfo}\n` +
                        `Parent error: ${err}`,
                );
            });

            const {httpCode} = pageDataLink;

            if (httpCode !== expectedCode) {
                throw new Error(
                    'Http-код не соответствует ожидаемому:\n' +
                        `Ожидаемый: ${expectedCode}\n` +
                        `Фактический: ${httpCode}\n` +
                        `${errInfo}`,
                );
            }

            report.pushInfo(
                `Проверена валидность ссылки: ${stringifyPageData(
                    pageDataLink,
                )}`,
            );
        });
}
