import IDataForRequestPage from '../../../common/interfaces/tests/IDataForRequestPage';
import IPageData from '../../../common/interfaces/tests/IPageData';
import IReport from '../../../common/interfaces/tests/IReport';

import getPage from './getPage';
import stringifyRequest from './stringifyRequest';
import stringifyPageData from './stringifyPageData';

export default async function compareHttpCodes(
    dataForRequestPages: IDataForRequestPage[],
    report: IReport,
): Promise<IPageData[]> {
    const pagesData = await Promise.all(
        dataForRequestPages.map(dataForRequestPage =>
            getPage(dataForRequestPage),
        ),
    ).catch(err => {
        throw new Error(
            'Ошибка при сравнении кодов ответа страниц:\n' +
                `${dataForRequestPages
                    .map(data => stringifyRequest(data))
                    .join('\n')}\n` +
                `Parent error: ${err}`,
        );
    });

    const pagesInfo = pagesData.map(data => stringifyPageData(data)).join('\n');

    if (
        !pagesData.every(
            pageData => pageData.httpCode === pagesData[0].httpCode,
        )
    ) {
        throw new Error(`Несоответствие кодов ответа:\n${pagesInfo}`);
    }

    report.pushInfo(`Проверены http-коды:\n${pagesInfo}`);

    return pagesData;
}
