import cheerio from 'cheerio';
import urlModule from 'url';

export default function getLinksFromPage(html: string, url: string): string[] {
    const $ = cheerio.load(html);

    const links: string[] = [];

    $('a').each((index, element) => {
        const href = element.attribs.href;

        if (href) {
            links.push(urlModule.resolve(url, href));
        }
    });

    return links;
}
