import got from 'got';

import IDataForRequestPage from '../../../common/interfaces/tests/IDataForRequestPage';
import IPageData from '../../../common/interfaces/tests/IPageData';

import parseCookieHeader from './parseCookieHeader';
import stringifyCookies from './stringifyCookies';

export default async function getPage({
    url,

    timeout = 20000,
    headers: headersFromProps = {},
    cookies = {},
    encoding = 'utf8',
    followRedirect = true,
}: IDataForRequestPage): Promise<IPageData> {
    const cookieHeader = headersFromProps.Cookie || '';
    const allCookie = {
        ...parseCookieHeader(cookieHeader),
        ...cookies,
    };
    const headers = {
        ...headersFromProps,
        Cookie: stringifyCookies(allCookie),
    };

    try {
        const result = await got(url, {
            timeout,
            headers,
            encoding,
            followRedirect,
            rejectUnauthorized: false,
        });

        return {
            body: result.body,
            httpCode: result.statusCode,
            headers,
            url,
        };
    } catch (err) {
        throw new Error(
            'Ошибка при получении страницы:\n' +
                `Headers: ${JSON.stringify(headers)}\n` +
                `Parent error: ${err}`,
        );
    }
}
