// Парсит содержимое кук из заголовков запроса (тех, с которыми производится запрос - requestHeaders)
export default function parseCookieHeader(
    cookieHeader: string,
): Record<string, string> {
    return cookieHeader
        .split(';')
        .map(valueString => valueString.trim())
        .filter(Boolean)
        .reduce<Record<string, string>>((result, valueString) => {
            const [key, value] = valueString.split('=').map(str => str.trim());

            if (key.length) {
                result[key] = value;
            }

            return result;
        }, {});
}
