/* eslint-disable no-console */
const fs = require('fs');
const path = require('path');
const urlJoin = require('url-join');
const errorTools = require('@yandex-vh/error-tools');

const config = require('../server/configs/default');

const buildStaticDir = 'static/bundle'; // Путь до папки со статикой в проекте
const projectName = 'travel';
const yaStaticPathPrefix = config.static.host; // https://yastat.net/s3/rasp/s/morda-front/release-0.1724.0

interface IBundleFile {
    /**
     * Путь до файла собранного проекта
     * @example static/bundle/modernMobile/ru/app.js
     */
    filePath: string;
    /**
     * Путь до .map файла собранного проекта
     * @example static/bundle/modernMobile/ru/app.js.map
     */
    mapFilePath: string;
}

function findMapFiles(
    directory,
    resultMapFilePaths: IBundleFile[] = [],
): IBundleFile[] {
    fs.readdirSync(directory).forEach((file: string) => {
        const filePath = path.resolve(directory, file);
        const stat = fs.statSync(filePath);

        if (stat.isDirectory()) {
            findMapFiles(path.join(directory, file), resultMapFilePaths);
        } else if (stat.isFile() && file.endsWith('.js')) {
            const relativeFilePath = path.join(directory, file);
            const sourceMapFilePath = `${relativeFilePath}.map`;

            if (fs.existsSync(sourceMapFilePath)) {
                resultMapFilePaths.push({
                    filePath: relativeFilePath,
                    mapFilePath: sourceMapFilePath,
                });
            }
        }
    });

    return resultMapFilePaths;
}

const uploadJsMapFilesFromDir = (dir: string): void => {
    const mapFilePaths = findMapFiles(dir);

    mapFilePaths.forEach(({filePath, mapFilePath}) => {
        const yaStatFilePath = filePath.replace('static/', '');
        const yaStatFileUrl = urlJoin(yaStaticPathPrefix, yaStatFilePath);

        errorTools
            .uploadSourceMap(mapFilePath, yaStatFileUrl, projectName)
            .then(() => {
                console.log(
                    `Upload ${mapFilePath} succeeded. Bundle URL: ${yaStatFileUrl}`,
                );
            })
            .catch((e: Error) => {
                console.error(
                    `Upload ${mapFilePath} failed. Bundle URL: ${yaStatFileUrl}`,
                    e,
                );
            });
    });
};

uploadJsMapFilesFromDir(buildStaticDir);
