const path = require('path');

require('@babel/register')({
    extensions: ['.ts', '.tsx', '.js', '.mjs'],
    ignore: ['node_modules', 'static'],
});

if (require.main === module) {
    // Вызов из консоли работает как прокси к указанному в --path скрипту

    const argv = require('yargs/yargs')(process.argv.slice(2))
        .usage('Usage: $0 --path=relativePath -- --parameterForScript=test')
        .help('h')
        .alias('h', 'help')
        .option('path', {
            type: 'string',
            describe: 'relative path to file for transpile on fly',
            demandOption: true,
        }).argv;

    const pathScript = path.join(__dirname, argv.path);

    process.argv = [process.argv[0], pathScript, ...argv._];

    require('./defineEnvironment');
    require(pathScript);
}
