import {PluginItem, PluginOptions} from '@babel/core';

export function patchOptionsPresetAndPlugins(
    source: PluginItem[],
    name: string,
    newOptions: PluginOptions,
): PluginItem[] {
    return source.map(element => {
        const nameElement = Array.isArray(element) ? element[0] : element;

        if (nameElement !== name) {
            return element;
        }

        return [name, newOptions];
    });
}
