import MiniCssExtractPlugin from 'mini-css-extract-plugin';

import {getHostForImages} from './staticUtils';

export default function (): object[] {
    return [
        {
            test: /common\/components\/(.*)\/(.*)\.([jt]sx?|mjs)$/,
            loader: 'dependency-loader',
            options: {
                injections: ['[name].styl'],
            },
        },
        {
            test: /\.styl$/,
            use: [
                MiniCssExtractPlugin.loader,
                {
                    loader: 'css-loader',
                    options: {importLoaders: 1},
                },
                {
                    loader: 'stylus-loader',
                    options: {
                        stylusOptions: {
                            define: [['$staticImagesPath', getHostForImages()]],
                        },
                    },
                },
            ],
        },
    ];
}
