import webpack from 'webpack';
import environment from '@yandex-int/yandex-environment';

import Platform from '../common/interfaces/Platform';
import Lang from '../common/interfaces/Lang';

import {getHostForImages} from './staticUtils';

interface IGetDefinePlugin {
    platform: Platform;
    language: Lang;
}

export default function getDefinePlugin({
    platform,
    language,
}: IGetDefinePlugin): webpack.DefinePlugin {
    const imagesPath = getHostForImages();

    return new webpack.DefinePlugin({
        'process.env.NODE_ENV': JSON.stringify(environment),
        'process.env.PLATFORM': JSON.stringify(platform),
        'process.env.BUNDLE_LANGUAGE': JSON.stringify(language),
        'process.env.IMAGES_PATH': JSON.stringify(imagesPath),
    });
}
