import TerserPlugin from 'terser-webpack-plugin';

import WebpackMode from '../common/interfaces/WebpackMode';

export default function getMinimizeOptimization(
    mode: WebpackMode,
): Record<string, any> {
    return {
        minimize: mode === WebpackMode.production,
        minimizer: [
            new TerserPlugin({
                terserOptions: {
                    safari10: true,
                },
            }),
        ],
    };
}
