import PostCSSAssetsPlugin from 'postcss-assets-webpack-plugin';
import autoprefixer from 'autoprefixer';
import cssnano from 'cssnano';

import deduplicate from '../packages/postcss-discard-duplicates/dist/index';

import WebpackMode from '../common/interfaces/WebpackMode';

export default function getPostCSSAssetsPlugin(
    supportedBrowsers: string[],
    mode: WebpackMode,
): PostCSSAssetsPlugin {
    return new PostCSSAssetsPlugin({
        test: /\.css$/,
        log: false,
        plugins: [
            autoprefixer({grid: true, overrideBrowserslist: supportedBrowsers}),
            ...(mode === WebpackMode.development
                ? []
                : [
                      cssnano({
                          preset: [
                              'default',
                              {
                                  discardDuplicates: false,
                                  autoprefixer: false,
                              },
                          ],
                      }),
                  ]),
            deduplicate({reverseRemoval: true}),
        ],
    });
}
