const fs = require('fs');
const path = require('path');

export default function (): {
    alias: {[key: string]: string};
    extensions: string[];
} {
    const rootPath = fs.realpathSync(process.cwd());

    return {
        alias: {
            common: path.join(rootPath, 'common'),
        },
        extensions: ['.ts', '.tsx', '.js', '.mjs', '.json'],
    };
}
