import {BROWSER_LIST, MODERN_BROWSER_LIST} from './supportedBrowsers';

import Platform from '../common/interfaces/Platform';

export default function getSupportedBrowsers(
    platform?: Platform,
    modernBrowser = false,
): string[] {
    const browserList = modernBrowser ? MODERN_BROWSER_LIST : BROWSER_LIST;

    if (!platform) {
        return [...browserList.desktop, ...browserList.mobile];
    }

    return platform === Platform.desktop
        ? browserList.desktop
        : browserList.mobile;
}
