import SvgStorePluginImport from 'webpack-external-svg-sprite';
import svgoUniqueId from 'svgo-unique-id';
import path from 'path';

import {SPRITE_NAME} from './staticUtils';

export default function getSvgBundlePlugin(
    pathToSVGFolder: string,
): SvgStorePluginImport {
    // Чистим кэш модуля. Из-за того, что переменная в которой хранится svg-бандл одна на весь модуль,
    // при инициализации двух svg-бандлов они попадают в обе сборки.
    // А если названия бандлов одинаковые, то бандл и вовсе склеится
    delete require.cache[require.resolve('webpack-external-svg-sprite')];

    const SvgStorePlugin = require('webpack-external-svg-sprite');

    return new SvgStorePlugin({
        emit: true,
        directory: path.join(__dirname, '../', pathToSVGFolder),
        name: SPRITE_NAME,
        prefix: 'icon-',
        suffix: '',
        svgoOptions: {
            plugins: [
                {removeUselessStrokeAndFill: false},
                {uniqueID: svgoUniqueId},
                {removeTitle: true},
            ],
        },
    });
}
