import path from 'path';
import WriteFilePlugin from 'write-file-webpack-plugin';

import {NODE_BUNDLE_NAME} from './staticUtils';

import IWebpackConfig from '../common/interfaces/IWebpackConfig';

// eslint-disable-next-line no-duplicate-imports
import {getHostForBundle, getPathForBundle} from './staticUtils';
import getDevtool from './getDevtool';
import getJsRules from './getJsRules';
import getDefinePlugin from './getDefinePlugin';
import getStats from './getStats';
import getResolve from './getResolve';

const target = 'node';

export default function ({
    platform,
    language,
    mode,
    modernBrowser,
}: IWebpackConfig): Record<string, any> {
    const bundlePath = getPathForBundle({platform, language, modernBrowser});
    const bundleHost = getHostForBundle({platform, language, modernBrowser});

    return {
        entry: {
            [NODE_BUNDLE_NAME]: path.join(__dirname, '../common/server.js'),
        },
        output: {
            path: bundlePath,
            publicPath: bundleHost,
            filename: '[name].js',
            libraryTarget: 'commonjs2',
        },
        mode,
        target,
        watch: false,
        bail: true,
        profile: true,
        devtool: getDevtool(),
        stats: getStats(),
        resolve: getResolve(),
        module: {
            rules: [...getJsRules(target, platform, modernBrowser)],
        },
        plugins: [
            getDefinePlugin({platform, language}),

            new WriteFilePlugin({
                test: /\.js(\.map)?$/,
                log: false,
                exitOnErrors: false,
            }),
        ],
    };
}
