import path from 'path';
import WriteFilePlugin from 'write-file-webpack-plugin';

import {NODE_BUNDLE_NAME} from './staticUtils';

import IWebpackConfig from '../common/interfaces/IWebpackConfig';
import Platform from '../common/interfaces/Platform';

// eslint-disable-next-line no-duplicate-imports
import {getPathForInformerBundle} from './staticUtils';
import getDevtool from './getDevtool';
import getJsRules from './getJsRules';
import getDefinePlugin from './getDefinePlugin';
import getStats from './getStats';
import getResolve from './getResolve';

const target = 'node';

export default function ({
    language,
    mode,
}: IWebpackConfig): Record<string, any> {
    const bundlePath = getPathForInformerBundle({language});

    return {
        entry: {
            [NODE_BUNDLE_NAME]: path.join(
                __dirname,
                '../common/components/RootInformers/RootInformers.tsx',
            ),
        },
        output: {
            path: bundlePath,
            publicPath: '',
            filename: '[name].js',
            libraryTarget: 'commonjs2',
        },
        mode,
        target,
        watch: false,
        bail: true,
        profile: true,
        devtool: getDevtool(),
        stats: getStats(),
        resolve: getResolve(),
        module: {
            rules: [...getJsRules(target)],
        },
        plugins: [
            getDefinePlugin({platform: Platform.desktop, language}),

            new WriteFilePlugin({
                test: /\.js(\.map)?$/,
                log: false,
                exitOnErrors: false,
            }),
        ],
    };
}
