import yaConfig from '@yandex-int/yandex-config';
import path from 'path';
import upperFirst from 'lodash/upperFirst';

import Platform from '../common/interfaces/Platform';
import Lang from '../common/interfaces/Lang';

export const SPRITE_NAME = 'sprite.svg';
export const NODE_BUNDLE_NAME = 'node';

const config = yaConfig();

const USE_STATIC_FROM_INSTANCE = process.env.RASP_CONTAINER_RUN_LOCALLY === '1';

export function getHostForStaticWithVersion(): string {
    return USE_STATIC_FROM_INSTANCE ? '/static' : config.static.host;
}

export function getHostForStaticWithoutVersion(): string {
    return USE_STATIC_FROM_INSTANCE
        ? '/static/_'
        : config.static.hostWithoutVersion;
}

export interface IBundlePath {
    platform: Platform;
    language: Lang;
    modernBrowser: boolean;
}

export interface IInformerBundlePath {
    language: Lang;
}

// Возвращает часть пути к бандлу, специфичную для браузера
export function getBrowserPath(
    platform: Platform,
    modernBrowser: boolean,
): string {
    return modernBrowser ? `modern${upperFirst(platform)}` : platform;
}

// Возвращает абсолютный путь до бандла
export function getPathForBundle({
    platform,
    language,
    modernBrowser,
}: IBundlePath): string {
    return `${path.join(__dirname, '../static/bundle')}/${getBrowserPath(
        platform,
        modernBrowser,
    )}/${language}`;
}

// Возвращает абсолютный путь до бандла информеров
export function getPathForInformerBundle({
    language,
}: IInformerBundlePath): string {
    return `${path.join(__dirname, '../static/informerBundle')}/${language}`;
}

// Возвращает абсолютный урл для бандла
export function getHostForBundle({
    platform,
    language,
    modernBrowser,
}: IBundlePath): string {
    return `${getHostForStaticWithVersion()}/bundle/${getBrowserPath(
        platform,
        modernBrowser,
    )}/${language}`;
}

// Возвращает абсолютный урл для бандла информеров
export function getHostForInformerBundle({
    language,
}: IInformerBundlePath): string {
    return `${getHostForStaticWithVersion()}/informerBundle/${language}`;
}

export function getPathForReactLoadableJson({
    platform,
    language,
    modernBrowser,
}: IBundlePath): string {
    return `${getPathForBundle({
        platform,
        language,
        modernBrowser,
    })}/react-loadable.json`;
}

export function getPathForSvgSprite({
    platform,
    language,
    modernBrowser,
}: IBundlePath): string {
    return `${getPathForBundle({
        platform,
        language,
        modernBrowser,
    })}/${SPRITE_NAME}`;
}

export function getPathForInformerSvgSprite({
    language,
}: IInformerBundlePath): string {
    return `${getPathForInformerBundle({language})}/${SPRITE_NAME}`;
}

export function getHostForImages(): string {
    return `${getHostForStaticWithoutVersion()}/images`;
}

export function getPathForStaticWithoutVersion(): string {
    return path.join(__dirname, '../static/_');
}

export function getPathForFavicons(): string {
    return `${getPathForStaticWithoutVersion()}/favicons`;
}

export function getHostForFavicons(): string {
    return `${getHostForStaticWithoutVersion()}/favicons`;
}

export function getPathForNodeBundle({
    platform,
    language,
    modernBrowser,
}: IBundlePath): string {
    return `${getPathForBundle({
        platform,
        language,
        modernBrowser,
    })}/${NODE_BUNDLE_NAME}.js`;
}

export function getPathForNodeInformerBundle({
    language,
}: IInformerBundlePath): string {
    return `${getPathForInformerBundle({language})}/${NODE_BUNDLE_NAME}.js`;
}
