export const MIN_VERSIONS = {
    samsung: 2,
    chrome: 11,
    chromeMobile: 18,
    edge: 13,
    ie: 9,
    ieMobile: 10,
    opera: 12,
    operaMini: 4,
    operaMobile: 20,
    firefox: 38,
    firefoxMobile: 65,
    safari: 5,
    safariMobile: 5,
    androidBrowser: 2,
    UCBrowser: 9,
};

export const MODERN_VERSIONS = {
    chrome: 76,
    chromeMobile: 74,
    firefox: 69,
    firefoxMobile: 67,
    opera: 63,
    operaMobile: 46,
    safari: 12,
    safariMobile: 11,
    yandexBrowser: 19,
    samsung: 10,
};

export const BROWSER_LIST = {
    mobile: [
        `samsung >= ${MIN_VERSIONS.samsung}`,
        `ios >= ${MIN_VERSIONS.safariMobile}`,
        `chromeAndroid >= ${MIN_VERSIONS.chromeMobile}`,
        `android >= ${MIN_VERSIONS.androidBrowser}`,
        `ie_mob >= ${MIN_VERSIONS.ieMobile}`,
        `firefoxAndroid >= ${MIN_VERSIONS.firefoxMobile}`,
        `operaMini >= ${MIN_VERSIONS.operaMini}`,
        `operaMobile >= ${MIN_VERSIONS.operaMobile}`,
        `and_uc >= ${MIN_VERSIONS.UCBrowser}`,
    ],
    desktop: [
        `edge >= ${MIN_VERSIONS.edge}`,
        `ie >= ${MIN_VERSIONS.ie}`,
        `opera >= ${MIN_VERSIONS.opera}`,
        `firefox >= ${MIN_VERSIONS.firefox}`,
        `chrome >= ${MIN_VERSIONS.chrome}`,
        `safari >= ${MIN_VERSIONS.safari}`,
    ],
};

export const MODERN_BROWSER_LIST = {
    mobile: [
        `chromeAndroid >= ${MODERN_VERSIONS.chromeMobile}`,
        `firefoxAndroid >= ${MODERN_VERSIONS.firefoxMobile}`,
        `operaMobile >= ${MODERN_VERSIONS.operaMobile}`,
        `ios >= ${MODERN_VERSIONS.safariMobile}`,
        `samsung >= ${MODERN_VERSIONS.samsung}`,
    ],
    desktop: [
        `chrome >= ${MODERN_VERSIONS.chrome}`,
        `firefox >= ${MODERN_VERSIONS.firefox}`,
        `opera >= ${MODERN_VERSIONS.opera}`,
        `safari >= ${MODERN_VERSIONS.safari}`,
    ],
};
