import IABCConfig from '../types/IApiConfig/types/IABCConfig';
import IABCDuty from '../types/IABCDuty';

import getOAuthAuthorizationHeaders from '../utilities/getOAuthAuthorizationHeaders';

import BaseService from './base';

export default class ABCApi extends BaseService {
    constructor(params: IABCConfig) {
        super({
            prefixUrl: params.baseUrl,
            headers: getOAuthAuthorizationHeaders(params.oAuth),
        });
    }

    getOnDuty(serviceSlug: string): Promise<IABCDuty[]> {
        return this.request<IABCDuty[]>('duty/on_duty/', {
            method: 'GET',
            searchParams: {
                service__slug: serviceSlug,
            },
        });
    }
}
