import got, {Got, Options, OptionsOfJSONResponseBody} from 'got';

export default class BaseService {
    client: Got;

    constructor(options: Options) {
        this.client = got.extend({
            timeout: 3000,
            https: {
                rejectUnauthorized: false,
            },
            ...options,
        });
    }

    async request<ReturnType extends unknown>(
        path: string,
        options?: OptionsOfJSONResponseBody,
    ): Promise<ReturnType> {
        return this.client(path, options).json();
    }
}
