import S3Storage from './s3storage';
import TelegrafApi from './telegraf';
import TelegramApi from './telegram';
import StartrekApi from './startrek';
import StaffApi from './staff';
import config from '../configs/api';
import ABCApi from './abc';

class Api {
    startrek: StartrekApi;
    staff: StaffApi;
    abc: ABCApi;
    telegram: TelegramApi;
    telegraf: TelegrafApi;
    storage: S3Storage;

    constructor() {
        this.startrek = new StartrekApi(config.startrek);
        this.staff = new StaffApi(config.staff);
        this.abc = new ABCApi(config.abc);
        this.telegram = new TelegramApi(config.telegram);
        this.telegraf = new TelegrafApi(config.telegram);
        this.storage = new S3Storage(config.s3);
    }
}

export default new Api();
