import IStaffConfig from '../types/IApiConfig/types/IStaffConfig';
import IStaffPerson from '../types/IStaffPerson';

import getOAuthAuthorizationHeaders from '../utilities/getOAuthAuthorizationHeaders';

import BaseService from './base';

export default class StaffApi extends BaseService {
    constructor(params: IStaffConfig) {
        super({
            prefixUrl: params.baseUrl,
            headers: getOAuthAuthorizationHeaders(params.oAuth),
        });
    }

    getPerson(login: string): Promise<IStaffPerson> {
        return this.request<IStaffPerson>('persons', {
            searchParams: {
                login,
                _fields: 'login,telegram_accounts',
                _one: 1,
            },
        });
    }
}
