import IStartrekConfig from '../types/IApiConfig/types/IStartrekConfig';
import IStartrekIssue from '../types/IStartrekIssue';

import getOAuthAuthorizationHeaders from '../utilities/getOAuthAuthorizationHeaders';

import BaseService from './base';

export default class StartrekApi extends BaseService {
    constructor(params: IStartrekConfig) {
        super({
            prefixUrl: params.baseUrl,
            headers: getOAuthAuthorizationHeaders(params.oAuth),
        });
    }

    getIssue(issueId: string): Promise<IStartrekIssue> {
        return this.request<IStartrekIssue>(`issues/${issueId}`);
    }
}
