import {ExtraReplyMessage} from 'telegraf/typings/telegram-types';

import {dutyChatId} from '../configs/constants';

import IChatIdAndMessageId from '../types/IChatIdAndMessageId';

import getStartrekIssueUrl from '../utilities/getStartrekIssueUrl';
import logger from '../utilities/logger';
import getStartrekIssueStatus from '../utilities/getStartrekIssueStatus';

import api from '../api';

export async function onIssueStatusChanged(
    issueId: string,
    status: string,
): Promise<void> {
    const issue = await api.startrek.getIssue(issueId);

    if (!issue.assignee) {
        logger.logWarn(`Issue ${issue.key} does not have assignee`);

        return;
    }

    const person = await api.staff.getPerson(issue.assignee.id);

    const telegramLogin = person.telegram_accounts[0]?.value;

    if (!telegramLogin) {
        logger.logWarn(
            `Telegram login is not defined in Staff for "${person.login}"`,
        );

        return;
    }

    const chatId = await api.storage.getChatIdByAccount(telegramLogin);

    if (!chatId) {
        logger.logWarn(
            `Telegram login "${telegramLogin}" have not started conversation with release bot yet`,
        );

        return;
    }

    await api.telegram.sendMessage(
        chatId,
        [
            `Задача "${issue.key}: ${issue.summary}" ${getStartrekIssueStatus(
                status,
            )}`,
            getStartrekIssueUrl(issue.key),
        ].join('\n'),
    );
}

export async function onSendMessageInDutyChat(
    message: string,
    extra: ExtraReplyMessage = {},
): Promise<IChatIdAndMessageId> {
    const msg = await api.telegram.sendMessage(dutyChatId, message, extra);

    return {messageId: msg.message_id, chatId: dutyChatId};
}
