import * as md from '../../utilities/markdown';
import getReleaseType from './utilities/getReleaseType';
import getWarning from './utilities/getWarning';
import getLinks from './utilities/getLinks';
import getMajorVersionFromSummary from './utilities/getMajorVersionFromSummary';
import getServiceName from './utilities/getServiceName';

interface ICreateReleaseNotificationParams {
    ticketKey: string;
    status: string;
    components: string;
    summary: string;
    updatedBy: string;
    /**
     * ciUrl и version
     * Могут быть пустой строкой для статуса Открыт
     * Могут быть не актуальны для статуса Открыт
     */
    ciUrl: string;
    version: string;
}

export default function createReleaseNotification({
    ticketKey,
    ciUrl,
    version,
    components,
    summary,
    status,
    updatedBy,
}: ICreateReleaseNotificationParams): string {
    const type = getReleaseType(version, status);
    const serviceName = getServiceName(components);
    const warning = getWarning(status, updatedBy);
    const majorVersion = getMajorVersionFromSummary(summary);
    const links = getLinks(ticketKey, ciUrl, status);

    return [
        `${type} ${serviceName} ${md.bold(md.escape(majorVersion))}`,
        md.italic(status.toLowerCase()),
        '',
        ...(warning ? [warning, ''] : []),
        links,
    ]
        .filter(s => s !== null)
        .join('\n');
}
