import {EStartrekStatus} from '../../../configs/constants';

import getStartrekIssueUrl from '../../../utilities/getStartrekIssueUrl';
import * as md from '../../../utilities/markdown';

export default function getLinks(
    ticketKey: string,
    ciUrl: string | undefined,
    status: string,
): string {
    /**
     * Для открытых тикетов поле ciUrl не актуально
     */
    const trustedCiUrl = status === EStartrekStatus.OPEN ? undefined : ciUrl;

    return [
        {
            url: getStartrekIssueUrl(ticketKey),
            text: ticketKey,
        },
        {url: trustedCiUrl, text: 'CI Flow'},
    ]
        .map(({url, text}) => {
            if (!url) {
                return null;
            }

            return md.link(md.escape(text), url);
        })
        .filter(Boolean)
        .join(md.escape(' | '));
}
