import {EStartrekStatus} from '../../../configs/constants';

enum EReleaseType {
    FIX = 'Фикс',
    RELEASE = 'Релиз',
}

/**
 * Логика определения релиз сейчас или фикс по косвенным признакам
 * appVersion и status
 * так как appVersion проставляется отдельным кубиком после изменения статуса в тикете
 */
export default function getReleaseType(
    version: string,
    status: string,
): EReleaseType {
    /**
     * Если поле appVersion не проставлено, значит это точно новый тикет (релиз)
     */
    if (!version) {
        return EReleaseType.RELEASE;
    }

    /**
     * Если версия есть и статус открыт
     * значит было переоткрытие старого тикета, то есть фикс
     */
    if (status === EStartrekStatus.OPEN) {
        return EReleaseType.FIX;
    }

    /**
     * Для остальных статусов appVersion уже должно быть актуально
     * фикс можно определить по наличию точки в версии
     */
    const isFix = version.includes('.');

    if (isFix) {
        return EReleaseType.FIX;
    }

    return EReleaseType.RELEASE;
}
