import {componentsName} from '../../../configs/constants';

export default function getServiceName(components: string): string {
    const unknownName = 'безымянного сервиса';

    const serviceComponent = components
        .split(',')
        .map(c => c.trim())
        .find(component => Boolean(componentsName[component]));

    if (!serviceComponent) {
        return unknownName;
    }

    return componentsName[serviceComponent];
}
