import {EStartrekStatus, travelRobotName} from '../../../configs/constants';

export default function getWarning(
    status: string,
    updatedBy: string,
): string | null {
    const isRobot = updatedBy === travelRobotName;

    if (isRobot) {
        return null;
    }

    if (status === EStartrekStatus.TESTED) {
        return 'Запустите шаг «Release ticket tested» в CI Flow для дальнейшего деплоя';
    }

    if (status === EStartrekStatus.CLOSED) {
        return 'Запустите шаг «Close release ticket» в CI Flow для завершения релиза';
    }

    return null;
}
