import IApiConfig from '../types/IApiConfig/IApiConfig';

import getEnvVariable, {
    EEnvironmentVariables,
} from '../utilities/getEnvVariable';

const [s3AccessKey, s3SecretAccessKey] = getEnvVariable(
    EEnvironmentVariables.S3_ACCESS_KEYS,
).split(':');

const apiPrefixes = getApiPrefixUrl(
    getEnvVariable(EEnvironmentVariables.APP_ENV),
);

const config: IApiConfig = {
    staff: {
        baseUrl: apiPrefixes.staff,
        oAuth: getEnvVariable(EEnvironmentVariables.STAFF_OAUTH_TOKEN),
    },
    abc: {
        baseUrl: apiPrefixes.abc,
        oAuth: getEnvVariable(EEnvironmentVariables.ABC_OAUTH_TOKEN),
    },
    startrek: {
        baseUrl: apiPrefixes.startrek,
        oAuth: getEnvVariable(EEnvironmentVariables.STARTREK_OAUTH_TOKEN),
    },
    telegram: {
        token: getEnvVariable(EEnvironmentVariables.TELEGRAM_TOKEN),
    },
    s3: {
        chatBucket: getEnvVariable(EEnvironmentVariables.CHAT_IDS_BUCKET),
        client: {
            accessKey: s3AccessKey,
            secretAccessKey: s3SecretAccessKey,
            baseUrl: apiPrefixes.s3,
        },
    },
};

export default config;

function getApiPrefixUrl(
    appEnv: string,
): Record<'staff' | 'abc' | 'startrek' | 's3', string> {
    const common = {
        staff: 'https://staff-api.yandex-team.ru/v3',
        startrek: 'https://st-api.yandex-team.ru/v2',
        abc: 'https://abc-back.yandex-team.ru/api/v4',
    };

    if (appEnv === 'production') {
        return {
            ...common,
            s3: 'https://s3.mds.yandex.net',
        };
    }

    return {
        ...common,
        s3: 'https://s3.mdst.yandex.net',
    };
}
