/**
 * Сообщение при смене дежурств
 */
import getEnvVariable, {
    EEnvironmentVariables,
} from '../utilities/getEnvVariable';

export const dutySwapNotifyConfig = {
    frontenders: {
        name: 'Фронтенд',
        slug: 'portalvteam',
        persons: {
            main: {
                name: 'Основной',
                slug: 'travel_portal_duty',
                scheduleUrl:
                    'https://abc.yandex-team.ru/services/portalvteam/duty/?role=705',
            },
            reserve: {
                name: 'Запасной',
                slug: 'travel_portal_duty_reserve',
                scheduleUrl:
                    'https://abc.yandex-team.ru/services/portalvteam/duty/?role=704',
            },
        },
    },
    testers: {
        name: 'Тестирование',
        slug: 'yt_qas',
        persons: {
            main: {
                name: 'Основной',
                slug: 'release_test',
                scheduleUrl: 'https://abc.yandex-team.ru/services/yt_qas/duty/',
            },
        },
    },
};

export const dutySwapReminders = [
    'Заполнить [лог дежурств](https://wiki.yandex-team.ru/travel/travelfrontend/duty-logs/)',
    'Cписок [задач на дежурство](https://wiki.yandex-team.ru/travel/travelfrontend/duty-backlog/)',
];

export const travelRobotName = 'Робот YaTravel';

export const componentsName: Record<string, string> = {
    '$travel-frontend-portal': 'портала',
    '$travel-frontend-pdf': 'пдфницы',
    '$travel-frontend-rasp': 'расписаний',
};

export enum EStartrekStatus {
    OPEN = 'Открыт',
    TESTED = 'Протестировано',
    CLOSED = 'Закрыт',
}

export const pinnedMessagesKey = '_settings_pinnedMessages';

export const dutyChatId = getEnvVariable(
    EEnvironmentVariables.TELEGRAM_DUTY_CHAT_ID,
);
