import {Request, Response} from '@yandex-data-ui/core/build/types';

import * as notifications from '../components/notifications';

async function onSendMessageGet(req: Request, res: Response): Promise<void> {
    const {message} = req.query;

    try {
        await notifications.onSendMessageInDutyChat(message);

        res.sendStatus(200);
    } catch (err) {
        res.sendStatus(500);
    }
}

async function onSendMessagePost(req: Request, res: Response): Promise<void> {
    const {message} = req.body;

    try {
        await notifications.onSendMessageInDutyChat(message);

        res.sendStatus(200);
    } catch (err) {
        res.sendStatus(500);
    }
}

export default {
    onSendMessageGet,
    onSendMessagePost,
};
