import {Request, Response} from '@yandex-data-ui/core/build/types';

import logger from '../utilities/logger';

import * as notifications from '../components/notifications';
import createReleaseNotification from '../components/releases';

interface INotifyStatusRequest {
    version: string;
    ticketKey: string;
    ciUrl: string;
    status: string;
    components: string;
    summary: string;
    updatedBy: string;
}

async function onNotifyStatus(req: Request, res: Response): Promise<void> {
    const body: INotifyStatusRequest = req.body;

    try {
        logger.log('Notify release status started', body);

        const message = createReleaseNotification(body);

        await notifications.onSendMessageInDutyChat(message, {
            parse_mode: 'MarkdownV2',
        });

        res.sendStatus(200);
    } catch (e) {
        if (e instanceof Error) {
            logger.logError('Notify release status failed', e);
        }

        res.sendStatus(500);
    }
}

export default {
    onNotifyStatus,
};
