import {Request, Response} from '@yandex-data-ui/core/build/types';

import logger from '../utilities/logger';

import * as notifications from '../components/notifications';

async function onIssueStatusChanged(
    req: Request,
    res: Response,
): Promise<void> {
    const {issueId} = req.params;
    const {status} = req.query;

    try {
        await notifications.onIssueStatusChanged(issueId, status);

        res.sendStatus(200);
    } catch (err) {
        if (err instanceof Error) {
            logger.logError(
                'Не удалось оповестить о смене статуса задачи',
                err,
            );
        }

        res.sendStatus(500);
    }
}

export default {
    onIssueStatusChanged,
};
